@section('description', $post->description)

@section('tags', $post->tags)
@section('image', asset("/img/logo.png"))

@extends('layouts.app')
@section('title', 'Blog - ' . config('app.name'))
@include('include.menu-estetica')
@section('head')
<link href="{{ asset('css/blog.css') }}" rel="stylesheet">
<link href="{{ asset('css/menu-blog.css') }}" rel="stylesheet">
<link href="{{ asset('css/menu-atendimento.css') }}" rel="stylesheet">
@endsection

@section('content')

<div class="cor-roxa col-12 px-0">
    <div class="row justify-content-center text-center w-100">
        <div class="col-12 ">
            <h1 class="">Um pouco mais sobre odontologia</h1>
        </div>
        <div class="col-12 col-lg-8">
            <h2>
                O Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500.
            </h2>
        </div>
    </div>
</div>

<div id="noticias1" class="noticias">
	<div class="container">
		<div class="row">
			<div class="col-lg-7 text-center text-lg-start">
				<div class="row">
					<h4><?php echo $post->title; ?></h4>
					<div class="hr"></div>
					<div class="data pb-3">
						<i class="fa fa-clock-o" aria-hidden="true" style="color:#F1D449"></i> {{ date_format(date_create($post->created_at), "d/m/Y") }}
					</div>
						<div class="noticias-img mb-5" style="background-image:url('{{ $post->image }}');">
						</div>

					<div style="text-align: justify; ">
						{!! $post->content !!}
					</div>
				</div>
				<hr />
				<a href="{{ route('blog-estetica') }}" class="btn btn-default" style="font-family: montserrat; border-radius: 4px; background-color: #8b519f; color: white; margin-bottom:10px;">Voltar </a>
			</div>

			<div class="col-lg-3 noticias-lateral text-center">
				<img src="/img/logo.png" class="img-fluid center-block wow fadeInRight hidden-xs img-fluid" data-wow-delay="0.2s">
				<hr class="hidden-xs" />

				<div class="wow fadeInRight" data-wow-delay="0.4s">
					<h4 align="center" style="color:#002B4E">Últimas Postagens</h4>
				@foreach($posts as $ul_post)
							<a style="color:black" href='{{ route('postEstetica', $ul_post->id) }}'> - {{ $ul_post->title }}</a>
							<br />
							@endforeach
					<br />
				</div>
				<hr />

				<h4 align="center" class="wow fadeInRight" data-wow-delay="1s">Arquivos</h4>
				{!! $arquivo !!}

			</div>
		</div>
	</div>
</div>
<section id="banner">
    <div class="container-fluid">
        <div class="row justify-content-center text-center w-100">
            <div class="col-11 col-md-9 col-lg-6 box">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <h2>Vamos trabalhar juntos?</h2>
                    </div>
                    <div class="col-12 col-lg-10 my-3">
                        <p>
                            Mande uma mensagem a qualquer momento para tirar suas dúvidas e conversar.
                        </p>
                    </div>
                    <div class="col-12 col-lg-4 mb-3 text-break">
                        <span>
                            <ion-icon class="icon" name="logo-whatsapp"></ion-icon> (19) 9 9369-8413
                        </span>
                    </div>
                    <div class="col-12 col-lg-5 mt-lg-1 mb-3 text-break">
                        <a href="" target="_blank">
                            Fale comigo agora mesmo <ion-icon class="arrow" name="chevron-forward">
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@include('include.footer')
@endsection


