@section('description', "")

@section('tags', "")
@section('image', asset("/img/logo.png"))

@extends('layouts.app')
@section('title', 'Blog - ' . config('app.name'))
@include('include.menu-atendimento')
@section('head')
<link href="{{ asset('css/blog.css') }}" rel="stylesheet">
<link href="{{ asset('css/menu-blog.css') }}" rel="stylesheet">
<link href="{{ asset('css/menu-atendimento.css') }}" rel="stylesheet">
@endsection

@section('content')

<div class="cor-roxa col-12 px-0">
    <div class="row justify-content-center text-center w-100">
        <div class="col-12 ">
            <h1 class="">Um pouco mais sobre odontologia</h1>
        </div>
        <div class="col-12 col-lg-8">
            <h2>
                O Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500.
            </h2>
        </div>
    </div>
</div>

<section id="blog-meio">
    <div class="container-fluid">
        <div class="row justify-content-center  g-0">
            <div class="col-12 col-md-10 col-lg-9 px-lg-4 text-center py-5 ">
                <div class="row justify-content-center justify-content-md-start text-center mt-5">

                    <?php foreach ($posts as $post) : ?>
                        <div class="col-10 col-md-5 mb-4">
                            <div class="card">
                                <div class="imagem-post" style="background-image:url({{ $post->image }})"></div>
                                <div class="card-body text-center col-10 col-lg-11 mx-auto">
                                    <span class="pb-3" style="color: #9F9F9F;">
                                        <ion-icon name="calendar" class="icone  pe-2"></ion-icon><?= date_format(date_create($post->created_at), 'd/m/Y') ?>
                                    </span>
                                    <h5 class="card-title pt-4"><?= $post->title ?></h5>
                                </div>
                                <div class="col-12 text-center pb-3 ps-3">
                                    <a href="{{ route('postAtendimento', $post->id) }}" class="btn btn-blog-mais">VER MAIS <ion-icon name="caret-forward" class="icone-bt"></ion-icon></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>

                </div>
            </div>

            <div class="col-8 col-sm-4 col-md-3 col-lg-2 pt-lg-5 mt-lg-5 mb-5 mb-lg-0">
                <h4 class="py-2 ps-3" class="wow fadeInRight text-center text-lg-start" data-wow-delay="1s">Arquivos</h4>
                {!! $arquivo !!}
            </div>

        </div>
    </div>
</section>

<section id="contato">
    <div class="container-fluid">
        <div class="row justify-content-center row1 text-lg-start text-center">
            <div class="col-12 col-md-8 col-lg-5 me-lg-5 mt-lg-4">
                <div class="row justify-content-center ">
                    <h2>Nós vamos até você!</h2>
                    <p>
                        Nossa área de atuação principal é na região de Indaiatuba, Campinas e Jundiaí. Se você reside em outras localidades, entre em contato.
                    </p>
                </div>
            </div>
            <div class="col-12 col-lg-4">
                <div class="row justify-content-center">
                    <div class="col-12 col-lg-1">
                        <ion-icon class="info-icon" name="logo-whatsapp"></ion-icon>
                    </div>
                    <div class="col-12 col-lg-11 my-2 pt-2 pt-lg-0 text-break">
                        <a href="https://api.whatsapp.com/send?phone=5519993698413" target="_blank">
                            <span>
                                (19) 9 9369-8413
                            </span>
                        </a>
                    </div>
                    <div class="col-12 col-lg-1 mt-2">
                        <ion-icon class="info-icon" name="mail"></ion-icon>
                    </div>
                    <div class="col-12 col-lg-11 my-3 pt-2 pt-lg-0 text-break">
                        <a href="mailto:contato@dentistanasuacasa.com.br">
                            <span>contato@dentistanasuacasa.com.br</span>
                        </a>
                    </div>
                    <div class="col-12 col-lg-1 text-break">
                        <ion-icon class="info-icon" name="location"></ion-icon>
                    </div>
                    <div class="col-12 col-lg-11 mt-2 pt-3 pt-lg-0 text-break">
                        <a href="https://g.page/dentista-na-sua-casa?share" target="_blank">
                            <span>
                                Indaiatuba, Campinas e região
                            </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <iframe class="m-0" src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d469818.0197558803!2d-47.07772!3d-23.0804971!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x14103b4aca1c7276!2sDentista%20na%20sua%20casa!5e0!3m2!1spt-BR!2sbr!4v1648655479345!5m2!1spt-BR!2sbr" width="100%" height="350" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
</section>
@include('include.footer')
@endsection