{{-- Base --}}
<title>@yield('title', config('app.name'))</title>
<meta name="description" content="@yield('description')">
<meta name="keywords" content="@yield('tags')">

{{-- Facebook --}}
<meta property="og:title" content="@yield('title', config('app.name'))" />
<meta property="og:type" content="@yield('type', config('app.type'))" />
<meta property="og:site_name" content="{{ config('app.name') }}" />
<meta property="og:url" content="{{ url()->current() }}" />
<meta property="og:image" content="@yield('image')" />
<meta property="og:description" content="@yield('description')" />
<meta property="og:locale" content="{{ str_replace('-', '_', app()->getLocale()) }}" />

{{-- Twitter --}}
<meta property="twitter:title" content="@yield('title', config('app.name'))" />
<meta property="twitter:description" content="@yield('description')" />
<meta property="twitter:image" content="@yield('image')" />
<meta property="twitter:url" content="{{ url()->current() }}" />
<meta property="twitter:card" content="summary" />

{{-- Favicon --}}
<link rel="icon" type="image/png" sizes="32x32" href="img/favicon/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="img/favicon/favicon-16x16.png">
<link rel="apple-touch-icon" sizes="57x57" href="img/favicon/apple-icon-57x57.png">
<link rel="manifest" href="img/favicon/manifest.json">
<meta name="msapplication-TileColor" content="#00FFFFFF">
<meta name="msapplication-TileImage" content="img/favicon/ms-icon-144x144.png">
<meta name="theme-color" content="#00FFFFFF">

@if (config('app.google_ua_code')!=false && config('app.google_ua_code')!=NULL)
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id={{ config('app.google_ua_code') }}"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', '{{ config('app.google_ua_code') }}');
    </script>
@endif

<!-- Event snippet for [Whatsapp] Contato conversion page
In your html page, add the snippet and call gtag_report_conversion when someone clicks on the chosen link or button. -->
<script>
    function gtag_report_conversion(url) {
      var callback = function () {
        if (typeof(url) != 'undefined') {
          window.location = url;
        }
      };
      gtag('event', 'conversion', {
          'send_to': 'AW-623009395/EAfuCLiCw4EYEPO8iakC',
          'event_callback': callback
      });
      return false;
    }
</script>
