<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|min:3|max:50',
            'password' => 'confirmed',
        ];
    }

    public function messages()
    {
        return [
            'name.required' => 'O campo Nome é obrigatório',
            'name.min' => 'O campo Nome deve ter no mínimo :min caracteres',
            'name.max' => 'O campo Nome deve ter no máximo :max caracteres',

            'password.required' => 'O campo Senha é obrigatório',
            'password.min' => 'Sua senha deve ter pelo menos :min caracteres',
            'password.confirmed' => 'A confirmação da nova senha deve ser igual ao campo nova senha!',
        ];
    }
}
