<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Modules\Blog\Entities\BlogPosts;

class SitePagesController extends Controller
{
    public static function Pages()
    {
        $static_pages =
            [
                'home'
            ];

        $pages[] = [
            'url' => route('home'),
            'last_modified' => now(),
            'priority' => 1.0
        ];

        foreach ($static_pages as $sp) {
            $pages[] = [
                'url' => route($sp),
                'last_modified' => now(),
                'priority' => 1.0
            ];
        }

        $posts = BlogPosts::where('status', true)->get();

        foreach ($posts as $post) {
            $pages[] = [
                'url' => route('post', $post->id),
                'last_modified' => $post->updated_at,
                'priority' => 0.8
            ];
        }

        return $pages;
    }
}
