<?php

namespace App\Http\Controllers;

use App\Http\Requests\NewUserRequest;
use App\Http\Requests\UserRequest;
use App\Models\User;
use Illuminate\Http\Request;
use Nwidart\Modules\Facades\Module;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;

class IntranetController extends Controller
{
    public function index()
    {
        return view('intranet.index');
    }

    public function minhaconta()
    {
        $user = User::findOrFail(auth()->user()->id);
        return view('intranet.minhaconta', ['user' => $user]);
    }

    public function updateminhaconta(UserRequest $request)
    {
        $user = User::findOrFail(auth()->user()->id);

        if (Hash::check($request->currentPassword, $user->password)) {
            $user->name = $request->name;
            $request->password ? $user->password = Hash::make($request->password) : false;
            $user->save();
            return redirect(route('intranetMinhaconta'))->with(['sucesso' => 'Conta atualizada com sucesso']);
        } else {
            throw ValidationException::withMessages(['currentPassword' => 'Senha incorreta.']);
        }
    }

    public function usuarios()
    {
        $users = User::all();
        return view('intranet.usuarios', ['users' => $users]);
    }

    public function novaconta()
    {
        if (auth()->user()->id == 1) {
            $user = new User();
            return view('intranet.novaconta', ['user' => $user]);
        } else {
            return redirect(route('intranetIndex'));
        }
    }

    public function storeconta(NewUserRequest $request)
    {
        if (auth()->user()->id == 1) {
            $user = new User();
            $user->email = $request->email;
            $user->name = $request->name;
            $user->status = true;
            $user->password = Hash::make($request->password);
            $user->save();
            return redirect(route('intranetUsuarios'))->with(['sucesso' => 'Usuário criado com sucesso']);
        } else {
            return redirect(route('intranetIndex'));
        }
    }

    public function editarusuario($id)
    {
        if (auth()->user()->id == 1) {
            $user = User::findOrFail($id);
            return view('intranet.minhaconta', ['user' => $user]);
        } else {
            return redirect(route('intranetIndex'));
        }
    }

    public function updateusuario($id, UserRequest $request)
    {
        if (auth()->user()->id == 1) {
            $user = User::findOrFail($id);

            if (true) {
                $user->name = $request->name;
                $request->password ? $user->password = Hash::make($request->password) : false;
                $user->save();
                
                return redirect(route('intranetUsuarios'))->with(['sucesso' => 'Usuário atualizado com sucesso']);
            } else {
                throw ValidationException::withMessages(['currentPassword' => 'Senha incorreta.']);
            }
        } else {
            return redirect(route('intranetIndex'));
        }
    }

    public function destroyusuario($id)
    {
        if (auth()->user()->id == 1) {
            $user = User::findOrFail($id);
            if ($user->id != auth()->user()->id && $user->id != 1) {
                $user->delete();
                return redirect(route('intranetUsuarios'));
            } else {
                throw ValidationException::withMessages(['currentPassword' => 'Você não pode remover este usuário.']);
            }
        } else {
            return redirect(route('intranetIndex'));
        }
    }
}
